 ; Ŀ
 ;   Vess - Vessel constructor.                                            
 ;   Copyright 1994, 2010 by Rocket Software Ltd.                          
 ;                                                                         
 ; 
 (DEFUN C:VESS (/ *error* angb plid pele orth blip p1 ht wdth p2 p3 p4 hdist
                                                 vdist plin p5 elips1 elips2)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (setq angb (getvar "angbase"))
  (setvar "angbase" 0)
  (setq plid (getvar "plinewid"))
  (setvar "plinewid" 0)
  (setq pele (getvar "pellipse"))
  (setvar "pellipse" 1)
  (setq orth (getvar "orthomode"))
  (setvar "orthomode" 1)
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
 (defun *error* (shk)
  (setvar "plinewid" plid)
  (setvar "pellipse" pele)
  (setvar "angbase" angb)
  (setvar "orthomode" orth)
  (setvar "blipmode" blip)
  (if shk (write-line shk))
 (princ))
 ; Ŀ
 ;   Get some points.                                                      
 ; 
  (if (and (not (zerop (setq osmo (getvar "osmode"))))
           (/= 16384 (logand osmo 16384)))
      (prompt "* You Have Osnaps Set And Bad Things Will Happen. *\n"))
  (setq p1 (getpoint "Top left corner:"))
  (setq ht (getdist p1 "\nCylinder height (or <Return> to drag): "))
  (if ht
     (progn
          (setq wdth (getdist p1 "\nWidth: "))
          (setq p2 (polar p1 0 wdth))
          (setq p3 (polar p2 (* pi 1.5) ht))
          (setq p4 (polar p1 (* pi 1.5) ht)))
     (progn
          (setq p3 (getcorner p1 "Opposite corner:\n"))
          (setq p2 (cons (car p3) (cdr p1)))
          (setq p4 (cons (car p1) (cdr p3)))))
  (if (> (setq hdist (distance p1 p2)) (setq vdist (distance p1 p4)))
      (progn
           (command "pline" p3 p2 p3 p4 p1 "")
           (setq plin (entlast))
           (setq p5 (polar p1 (* pi 1.5) (/ vdist 2.0)))
           (setq p5 (polar p5 0 (/ vdist 4.0)))
           (command "ellipse" p1 p4 p5)
           (command "trim" (list plin p1) ""
                           (list (entlast) p5) "")
           (setq elips1 (entlast))
           (command "mirror" (entlast) ""
                             (setq p5 (polar p1 0 (/ hdist 2.0)))
                             (polar p5 (/ pi 2.0) 10)
                             "n")
           (setq elips2 (entlast))
           (command "line" p1 p2 "")
           (command "pedit" plin "j" elips1 elips2 (entlast) "" ""))
      (progn
           (command "pline" p1 p2 p3 p4 p3 "")
           (setq plin (entlast))
           (setq p5 (polar p1 0 (/ hdist 2.0)))
           (setq p5 (polar p5 (* pi 1.5) (/ hdist 4.0)))
           (command "ellipse" p1 p2 p5)
           (command "trim" (list plin p1) ""
                           (list (entlast) p5) "")
           (setq elips1 (entlast))
           (command "mirror" (entlast) ""
                             (setq p5 (polar p1 (* pi 1.5) (/ vdist 2.0)))
                             (polar p5 0 10)
                             "n")
           (setq elips2 (entlast))
           (command "line" p1 p4 "")
           (command "pedit" plin "j" elips1 elips2 (entlast) "" "")))
  (*error* nil)
 (princ))